/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.changeSignature;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.PyPsiIndexUtil;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyTupleParameter;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.refactoring.changeSignature.PyChangeSignatureDialog;
import com.jetbrains.python.refactoring.changeSignature.PyMethodDescriptor;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class PyChangeSignatureHandler
implements ChangeSignatureHandler {
    @Nullable
    public PsiElement findTargetMember(@NotNull PsiFile file, @NotNull Editor editor2) {
        if (file == null) {
            PyChangeSignatureHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            PyChangeSignatureHandler.$$$reportNull$$$0(1);
        }
        PsiElement element = PyUtil.findNonWhitespaceAtOffset((PsiFile)file, (int)editor2.getCaretModel().getOffset());
        return this.findTargetMember(element);
    }

    @Nullable
    public PsiElement findTargetMember(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        TypeEvalContext context = TypeEvalContext.codeInsightFallback((Project)element.getProject());
        PyCallExpression callExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyCallExpression.class);
        if (callExpression != null) {
            PyResolveContext resolveContext = PyResolveContext.implicitContext((TypeEvalContext)context);
            PyCallable resolved = (PyCallable)ContainerUtil.getFirstItem((List)callExpression.multiResolveCalleeFunction(resolveContext));
            return resolved instanceof PyFunction && PyiUtil.isOverload((PsiElement)resolved, (TypeEvalContext)context) ? PyiUtil.getImplementation((PyFunction)((PyFunction)resolved), (TypeEvalContext)context) : resolved;
        }
        PyFunction parent = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
        if (parent != null && PyiUtil.isOverload((PsiElement)parent, (TypeEvalContext)context)) {
            return null;
        }
        return parent;
    }

    public void invoke(@NotNull Project project, Editor editor2, PsiFile file, DataContext dataContext) {
        PsiElement element;
        if (project == null) {
            PyChangeSignatureHandler.$$$reportNull$$$0(2);
        }
        if ((element = this.findTargetMember(file, editor2)) == null) {
            element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        }
        PyChangeSignatureHandler.invokeOnElement(project, element, editor2);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, @Nullable DataContext dataContext) {
        if (project == null) {
            PyChangeSignatureHandler.$$$reportNull$$$0(3);
        }
        if (elements == null) {
            PyChangeSignatureHandler.$$$reportNull$$$0(4);
        }
        if (elements.length != 1) {
            return;
        }
        Editor editor2 = dataContext == null ? null : (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PyChangeSignatureHandler.invokeOnElement(project, elements[0], editor2);
    }

    @Nullable
    public String getTargetNotFoundMessage() {
        return PyBundle.message("refactoring.change.signature.error.wrong.caret.position.method.name", new Object[0]);
    }

    private static void invokeOnElement(Project project, PsiElement element, Editor editor2) {
        PyParameter[] parameters;
        if (element instanceof PyLambdaExpression) {
            PyChangeSignatureHandler.showCannotRefactorErrorHint(project, editor2, PyBundle.message("refactoring.change.signature.error.lambda.call", new Object[0]));
            return;
        }
        if (!(element instanceof PyFunction)) {
            PyChangeSignatureHandler.showCannotRefactorErrorHint(project, editor2, PyBundle.message("refactoring.change.signature.error.wrong.caret.position.method.name", new Object[0]));
            return;
        }
        PyFunction function = (PyFunction)element;
        if (PyPsiIndexUtil.isNotUnderSourceRoot((Project)project, (PsiFile)element.getContainingFile())) {
            PyChangeSignatureHandler.showCannotRefactorErrorHint(project, editor2, PyBundle.message("refactoring.change.signature.error.not.under.source.root", new Object[0]));
            return;
        }
        PyFunction superMethod = PyChangeSignatureHandler.getSuperMethod(function);
        if (superMethod == null) {
            return;
        }
        if (!superMethod.equals((Object)element)) {
            element = superMethod;
            if (PyPsiIndexUtil.isNotUnderSourceRoot((Project)project, (PsiFile)superMethod.getContainingFile())) {
                return;
            }
        }
        for (PyParameter p : parameters = function.getParameterList().getParameters()) {
            if (!(p instanceof PyTupleParameter)) continue;
            PyChangeSignatureHandler.showCannotRefactorErrorHint(project, editor2, PyBundle.message("refactoring.change.signature.error.tuple.parameters", new Object[0]));
            return;
        }
        PyMethodDescriptor method = new PyMethodDescriptor((PyFunction)element);
        PyChangeSignatureDialog dialog = new PyChangeSignatureDialog(project, method);
        dialog.show();
    }

    private static void showCannotRefactorErrorHint(@NotNull Project project, @Nullable Editor editor2, @NlsContexts.DialogMessage @NotNull String details) {
        if (project == null) {
            PyChangeSignatureHandler.$$$reportNull$$$0(5);
        }
        if (details == null) {
            PyChangeSignatureHandler.$$$reportNull$$$0(6);
        }
        String message = RefactoringBundle.getCannotRefactorMessage((String)details);
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)message, (String)RefactoringBundle.message((String)"changeSignature.refactoring.name"), (String)"refactoring.renameRefactorings");
    }

    @VisibleForTesting
    @ApiStatus.Internal
    @Nullable
    public static PyFunction getSuperMethod(@Nullable PyFunction function) {
        if (function == null) {
            return null;
        }
        PyClass containingClass = function.getContainingClass();
        if (containingClass == null) {
            return function;
        }
        if (PyUtil.isConstructorLikeMethod((PsiElement)function)) {
            return function;
        }
        PyFunction deepestSuperMethod = PySuperMethodsSearch.findDeepestSuperMethod((PyFunction)function);
        if (!deepestSuperMethod.equals((Object)function)) {
            String baseClassName;
            PyClass baseClass = deepestSuperMethod.getContainingClass();
            PyBuiltinCache cache2 = PyBuiltinCache.getInstance((PsiElement)baseClass);
            String string = baseClassName = baseClass == null ? "" : baseClass.getName();
            if (cache2.isBuiltin((PsiElement)baseClass)) {
                return function;
            }
            String message = PyBundle.message("refactoring.change.signature.find.usages.of.base.class", function.getName(), containingClass.getName(), baseClassName);
            int choice = Messages.showYesNoCancelDialog((Project)function.getProject(), (String)message, (String)RefactoringBundle.message((String)"changeSignature.refactoring.name"), (Icon)Messages.getQuestionIcon());
            return switch (choice) {
                case 0 -> deepestSuperMethod;
                case 1 -> function;
                default -> null;
            };
        }
        return function;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/refactoring/changeSignature/PyChangeSignatureHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findTargetMember";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "showCannotRefactorErrorHint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

