\name{BlackTopHatImageFilter}
\alias{BlackTopHatImageFilter}
\title{BlackTopHatImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Black top hat extracts local minima that are smaller than the
structuring element.
BlackTopHatImageFilter}
\details{
Black top hat extracts local minima that are smaller than the
structuring element. It subtracts the background from the input image.
The output of the filter transforms the black valleys into white
peaks.
Top-hats are described in Chapter 4.5 of Pierre Soille's book
"Morphological Image Analysis: Principles and Applications", Second
Edition, Springer, 2003.
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
See:
BlackTopHat for the procedural interface
itk::BlackTopHatImageFilter for the Doxygen on the original ITK class.
BlackTopHatImageFilter}
%C++ includes: sitkBlackTopHatImageFilter.h
\section{Methods}{
\describe{
\item{ BlackTopHatImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::vector< unsigned int > GetKernelRadius() const:}{
Get the radius of the kernel structuring element.
}
\item{KernelEnum GetKernelType() const:}{
Get the kernel or structuring element used for the morphology.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetSafeBorder() const:}{
A safe border is added to input image to avoid borders effects and
remove it once the closing is done
}
\item{Self SafeBorderOff():}{}
\item{Self SafeBorderOn():}{
Set the value of SafeBorder to true or false respectfully.
}
\item{Self SetKernelRadius(std::vector< unsigned int > KernelRadius):}{
Set the radius of the kernel structuring element.
}
\item{Self SetKernelRadius(unsigned int value):}{
Set the values of the KernelRadius vector all to value
}
\item{Self SetKernelType(KernelEnum KernelType):}{
Set the kernel or structuring element used for the morphology.
}
\item{Self SetSafeBorder(bool SafeBorder):}{
A safe border is added to input image to avoid borders effects and
remove it once the closing is done
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~BlackTopHatImageFilter():}{
Destructor
}
}
}
