/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.string;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Supplier;

public final class FileContents
implements Supplier<String> {
    private final Charset charset;
    private final Path file;

    public FileContents(Path file) {
        this(file, Charset.defaultCharset());
    }

    public FileContents(Path file, Charset charset) {
        this.file = Objects.requireNonNull(file, "No file path provided");
        this.charset = Objects.requireNonNull(charset, "No charset provided");
    }

    @Override
    public String get() {
        String output;
        try {
            output = new String(Files.readAllBytes(this.file), this.charset);
        }
        catch (IOException e) {
            return "";
        }
        return output;
    }

    public String toString() {
        return this.get();
    }
}

