/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.complex;

import net.snowflake.client.jdbc.internal.apache.arrow.log.ArrowLogger;
import net.snowflake.client.jdbc.internal.apache.arrow.log.ArrowLoggerFactory;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.OutOfMemoryException;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.DensityAwareVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FieldVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.FixedSizeListVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.ListVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.MapVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.StructVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.UnionVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.VectorWithOrdinal;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.ArrowType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.CallBack;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.ValueVectorUtility;

public abstract class AbstractContainerVector
implements ValueVector,
DensityAwareVector {
    static final ArrowLogger logger = ArrowLoggerFactory.getLogger(AbstractContainerVector.class);
    protected final String name;
    protected final BufferAllocator allocator;
    protected final CallBack callBack;

    protected AbstractContainerVector(String name, BufferAllocator allocator, CallBack callBack) {
        this.name = name;
        this.allocator = allocator;
        this.callBack = callBack;
    }

    public String toString() {
        return ValueVectorUtility.getToString(this, 0, this.getValueCount());
    }

    @Override
    public void allocateNew() throws OutOfMemoryException {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException();
        }
    }

    @Override
    public BufferAllocator getAllocator() {
        return this.allocator;
    }

    public FieldVector getChild(String name) {
        return this.getChild(name, FieldVector.class);
    }

    @Override
    public void close() {
        for (ValueVector vector : this) {
            vector.close();
        }
    }

    protected <T extends ValueVector> T typeify(ValueVector v, Class<T> clazz) {
        if (clazz.isAssignableFrom(v.getClass())) {
            return (T)((ValueVector)clazz.cast(v));
        }
        throw new IllegalStateException(String.format("Vector requested [%s] was different than type stored [%s]. Arrow doesn't yet support heterogeneous types.", clazz.getSimpleName(), v.getClass().getSimpleName()));
    }

    protected boolean supportsDirectRead() {
        return false;
    }

    public abstract int size();

    public abstract <T extends FieldVector> T addOrGet(String var1, FieldType var2, Class<T> var3);

    public abstract <T extends FieldVector> T getChild(String var1, Class<T> var2);

    public abstract VectorWithOrdinal getChildVectorWithOrdinal(String var1);

    public StructVector addOrGetStruct(String name) {
        return this.addOrGet(name, FieldType.nullable(new ArrowType.Struct()), StructVector.class);
    }

    public ListVector addOrGetList(String name) {
        return this.addOrGet(name, FieldType.nullable(new ArrowType.List()), ListVector.class);
    }

    public UnionVector addOrGetUnion(String name) {
        return this.addOrGet(name, FieldType.nullable(Types.MinorType.UNION.getType()), UnionVector.class);
    }

    public FixedSizeListVector addOrGetFixedSizeList(String name, int listSize) {
        return this.addOrGet(name, FieldType.nullable(new ArrowType.FixedSizeList(listSize)), FixedSizeListVector.class);
    }

    public MapVector addOrGetMap(String name, boolean keysSorted) {
        return this.addOrGet(name, FieldType.nullable(new ArrowType.Map(keysSorted)), MapVector.class);
    }

    @Override
    public void copyFrom(int fromIndex, int thisIndex, ValueVector from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copyFromSafe(int fromIndex, int thisIndex, ValueVector from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.name;
    }
}

